
/* Copyright 1989 UserLand Software, Inc.  All Rights Reserved.*/

/* file:	ipc.h
-- desc:	Public header file for IPCLib
-- version:	V1.0
-- by:		Don Park
-- when:	November 1988
-- hist:	30Nov88 V1.0 DDP	New.
*/

typedef Str255	PIN;	/* Process Name */
typedef	short	PID;	/* Process ID */

/* IPC specific error codes:
-- ipcErrBase:		Start of IPC error code range (expected to be negative).
-- ipcNSProcErr:	Specified Process (either by PID or PIN) is currently NOT
--					open.
-- ipcFullErr:		Too many IPC processes are open.
-- ipcBadPIDErr:	Given PID is NOT a valid PID.
-- ipcBadPINErr:	Given PIN is NOT a valid PIN.
-- ipcBadMsgErr:	Given Message is NOT a valid Message.
*/
#define	ipcErrBase		-2000
#define	ipcNSProcErr	(ipcErrBase - 0)
#define	ipcFullErr		(ipcErrBase - 1)
#define	ipcBadPIDErr	(ipcErrBase - 2)
#define	ipcBadPINErr	(ipcErrBase - 3)
#define	ipcBadMsgErr	(ipcErrBase - 4)

extern OSErr	ipcOpen			( PIN*, PID* );
extern OSErr	ipcClose		( PID );
extern OSErr	ipcFind			( PIN*, PID* );
extern OSErr	ipcWho			( PID, PIN* );

extern OSErr	ipcSend			( PID, PID, Handle );
extern OSErr	ipcReceive		( PID, PID*, Handle* );
extern OSErr	ipcClear		( PID );

#ifdef	GLOBALSOK
extern OSErr	ipcError		( void );
#endif